/*
 * Decompiled with CFR 0.152.
 */
package panther.util.resource;

import java.util.ArrayList;
import java.util.List;
import panther.util.resource.Resource;
import panther.util.resource.ResourceComponent;
import panther.util.resource.ResourceLog;
import panther.util.resource.ResourcePool;

public abstract class ResourceThing {
    protected long number;
    protected List components = new ArrayList();
    protected static long resourceThingCount = 1L;

    public ResourceThing() {
        this.number = ResourceThing.nextNumber();
    }

    public abstract boolean isActive();

    public abstract boolean released();

    public abstract boolean timedOut();

    public abstract Resource getTopResource();

    public ResourcePool getResourcePool() {
        return this.getTopResource() == null ? null : this.getTopResource().getResourcePool();
    }

    public ResourceLog getResourceLog() {
        return this.getTopResource() == null ? null : this.getTopResource().getResourceLog();
    }

    public long getNumber() {
        return this.number;
    }

    void clear() {
        this.closeComponents();
        this.components = null;
    }

    protected void closeComponents() {
        for (int i = 0; i < this.components.size(); ++i) {
            ResourceComponent resourceComponent = (ResourceComponent)this.components.get(i);
            resourceComponent.clear();
        }
        this.components.clear();
    }

    void addComponent(ResourceComponent resourceComponent) {
        this.components.add(resourceComponent);
    }

    void removeComponent(ResourceComponent resourceComponent) {
        this.components.remove(resourceComponent);
    }

    protected static synchronized long nextNumber() {
        return resourceThingCount++;
    }
}

